L = 128 # width and height of the community
J = L^2 # size of the community
M = matrix(0,L,L) # initial community contains only species 0
nu = 0.001 # speciation rate
sigma = 4 # standard deviation of dispersal kernel
next_sp_id = 1 # species id for the next speciation event

while ( sum(M==0) > 0 ) # loop over generations
  {
  xs_death = sample(L,J,replace=T)
  ys_death = sample(L,J,replace=T)
  xs_birth = (round(xs_death + rnorm(J,0,sigma)) - 1)%%L + 1
  ys_birth = (round(ys_death + rnorm(J,0,sigma)) - 1)%%L + 1
  do_speciation = (runif(J)<nu)

  # loop over the J birth-death events in this generation
  for ( i in 1:J )
    {
    if ( do_speciation[i] )
      {
      M[xs_death[i],ys_death[i]] = next_sp_id
      next_sp_id = next_sp_id + 1
      } else
      {
      M[xs_death[i],ys_death[i]] = M[xs_birth[i],ys_birth[i]]
      }
    }
  }

sp_ids = unique(as.vector(M))
M_display = matrix(match(M,sp_ids),L,L)
image(M_display,col=rainbow(length(sp_ids))) 
